<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Common;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class Services implements ResultInterface, \JsonSerializable
{
    /**
     * @var bool|null
     */
    private $cod;

    /**
     * @var float|null
     */
    private $cod_amount;

    /**
     * @var bool|null
     */
    private $exw;

    /**
     * @var bool|null
     */
    private $rod;

    /**
     * @var bool|null
     */
    private $pod;

    /**
     * @var bool|null
     */
    private $exc;

    /**
     * @var bool|null
     */
    private $ident;

    /**
     * @var bool|null
     */
    private $daw;

    /**
     * @var bool|null
     */
    private $ps;

    /**
     * @var bool|null
     */
    private $pr;

    /**
     * @var bool|null
     */
    private $s10;

    /**
     * @var bool|null
     */
    private $s12;

    /**
     * @var bool|null
     */
    private $sat;

    /**
     * @var bool|null
     */
    private $ow;

    /**
     * @var bool|null
     */
    private $srs;

    /**
     * @var bool|null
     */
    private $sds;

    /**
     * @var bool|null
     */
    private $cdx;

    /**
     * @var float|null
     */
    private $cdx_amount;

    /**
     * @var string|null
     */
    private $cdx_currency;

    /**
     * @var bool|null
     */
    private $ado;

    public function isCashOnDelivery(): bool
    {
        return true === $this->cod;
    }

    public function withCashOnDelivery(bool $cod): Services
    {
        $new = clone $this;
        $new->cod = $cod;

        return $new;
    }

    public function getCashOnDeliveryAmount(): ?float
    {
        return $this->cod_amount;
    }

    public function withCashOnDeliveryAmount(?float $codAmount): Services
    {
        $new = clone $this;
        $new->cod_amount = $codAmount;

        return $new;
    }

    public function isExWorks(): bool
    {
        return true === $this->exw;
    }

    public function withExWorks(bool $exw): Services
    {
        $new = clone $this;
        $new->exw = $exw;

        return $new;
    }

    public function isDocumentReturn(): bool
    {
        return true === $this->rod;
    }

    public function withDocumentReturn(bool $rod): Services
    {
        $new = clone $this;
        $new->rod = $rod;

        return $new;
    }

    public function isProofOfDelivery(): bool
    {
        return true === $this->pod;
    }

    public function withProofOfDelivery(bool $pod): Services
    {
        $new = clone $this;
        $new->pod = $pod;

        return $new;
    }

    public function isExchange(): bool
    {
        return true === $this->exc;
    }

    public function withExchange(bool $exc): Services
    {
        $new = clone $this;
        $new->exc = $exc;

        return $new;
    }

    public function isIdentification(): bool
    {
        return true === $this->ident;
    }

    public function withIdentification(bool $ident): Services
    {
        $new = clone $this;
        $new->ident = $ident;

        return $new;
    }

    public function isDeliveryAtWork(): bool
    {
        return true === $this->daw;
    }

    public function withDeliveryAtWork(bool $daw): Services
    {
        $new = clone $this;
        $new->daw = $daw;

        return $new;
    }

    public function isPickAndShip(): bool
    {
        return true === $this->ps;
    }

    public function withPickAndShip(bool $isPickAndShip): Services
    {
        $new = clone $this;
        $new->ps = $isPickAndShip;

        return $new;
    }

    public function isPickAndReturn(): bool
    {
        return true === $this->pr;
    }

    public function withPickAndReturn(bool $isPickAndReturn): Services
    {
        $new = clone $this;
        $new->pr = $isPickAndReturn;

        return $new;
    }

    public function isDeliveryBefore10(): bool
    {
        return true === $this->s10;
    }

    public function withDeliveryBefore10(bool $isDeliveryBefore10): Services
    {
        $new = clone $this;
        $new->s10 = $isDeliveryBefore10;

        return $new;
    }

    public function isDeliveryBefore12(): bool
    {
        return true === $this->s12;
    }

    public function withDeliveryBefore12(bool $isDeliveryBefore12): Services
    {
        $new = clone $this;
        $new->s12 = $isDeliveryBefore12;

        return $new;
    }

    public function isSaturdayDelivery(): bool
    {
        return true === $this->sat;
    }

    public function withSaturdayDelivery(bool $isSaturdayDelivery): Services
    {
        $new = clone $this;
        $new->sat = $isSaturdayDelivery;

        return $new;
    }

    public function getOw(): bool
    {
        return true === $this->ow;
    }

    public function withOw(bool $ow): Services
    {
        $new = clone $this;
        $new->ow = $ow;

        return $new;
    }

    public function isShopReturn(): bool
    {
        return true === $this->srs;
    }

    public function withShopReturn(bool $isShopReturn): Services
    {
        $new = clone $this;
        $new->srs = $isShopReturn;

        return $new;
    }

    public function isShopDelivery(): bool
    {
        return true === $this->sds;
    }

    public function withShopDelivery(bool $isShopDelivery): Services
    {
        $new = clone $this;
        $new->sds = $isShopDelivery;

        return $new;
    }

    public function getCdx(): bool
    {
        return true === $this->cdx;
    }

    public function withCdx(bool $cdx): Services
    {
        $new = clone $this;
        $new->cdx = $cdx;

        return $new;
    }

    public function getCdxAmount(): ?float
    {
        return $this->cdx_amount;
    }

    public function withCdxAmount(float $cdx_amount): Services
    {
        $new = clone $this;
        $new->cdx_amount = $cdx_amount;

        return $new;
    }

    public function getCdxCurrency(): ?string
    {
        return $this->cdx_currency;
    }

    public function Currency(string $cdx_currency): Services
    {
        $new = clone $this;
        $new->cdx_currency = $cdx_currency;

        return $new;
    }

    public function getAdo(): bool
    {
        return true === $this->ado;
    }

    public function withAdo(bool $ado): Services
    {
        $new = clone $this;
        $new->ado = $ado;

        return $new;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
