<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\ParcelShop;

use Gls\GlsPoland\AdePlus\Client as AdePlusClient;

final class Client implements ClientInterface
{
    private $client;

    public function __construct(AdePlusClient $client)
    {
        $this->client = $client;
    }

    public function getParcelShop(string $id): ParcelShop
    {
        $params = new SearchById($id);

        return $this->client->parcelShopSearchById($params);
    }
}
