<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gls\GlsPoland\AdePlus\ParcelShop\ParcelShop;
use Gls\GlsPoland\Cart\CartId;
use Gls\GlsPoland\Repository\CheckoutSessionRepository;

/**
 * @ORM\Entity(repositoryClass=CheckoutSessionRepository::class)
 * @ORM\Table(name=CheckoutSession::TABLE_NAME)
 */
class CheckoutSession
{
    /**
     * @internal
     */
    public const TABLE_NAME = _DB_PREFIX_ . 'gls_poland_checkout_session';

    /**
     * @ORM\Id()
     * @ORM\Column(type="integer", name="id_cart")
     */
    private $cartId;

    /**
     * @ORM\Column(type="json")
     */
    private $parcelShops = [];

    public function __construct(CartId $cartId)
    {
        $this->cartId = $cartId->getValue();
    }

    public function getCartId(): CartId
    {
        return CartId::from($this->cartId);
    }

    /**
     * @return array<int, string>
     */
    public function getParcelShopIds(): array
    {
        return $this->parcelShops;
    }

    public function getParcelShopId(int $carrierId): ?string
    {
        return $this->parcelShops[$carrierId] ?? null;
    }

    public function setParcelShop(ShopDeliveryCarrier $carrier, ParcelShop $parcelShop): self
    {
        $this->parcelShops[$carrier->getId()->getValue()] = $parcelShop->getId();

        return $this;
    }

    public function reset(): self
    {
        $this->parcelShops = [];

        return $this;
    }
}
