<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Labels;

use Gls\GlsPoland\Entity\Consignment;
use Gls\GlsPoland\EventDispatcher\Event;

final class LabelsEvent extends Event
{
    public const PREP_BOX_DOWNLOADED = 'gls_poland.labels.prep_box_downloaded';
    public const PRINT_BEFORE = 'gls_poland.labels.print_before';
    public const PRINTED = 'gls_poland.labels.print_after';

    private $consignment;

    public function __construct(Consignment $consignment)
    {
        $this->consignment = $consignment;
    }

    public function getConsignment(): Consignment
    {
        return $this->consignment;
    }
}
