<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Installer;

use Gls\GlsPoland\DependencyInjection\ServiceSubscriberInterface;
use Gls\GlsPoland\PrestaShop\CommandBus as BaseCommandBus;
use Gls\GlsPoland\PrestaShop\Message\CreateAdminTabCommand;
use Gls\GlsPoland\PrestaShop\Message\CreateCourierCarrierCommand;
use Gls\GlsPoland\PrestaShop\Message\CreateShopDeliveryCarrierCommand;
use Gls\GlsPoland\PrestaShop\Message\DeleteCarrierCommand;
use Gls\GlsPoland\PrestaShop\Message\ImportTranslationsCommand;
use Gls\GlsPoland\PrestaShop\MessageHandler\Carrier\CreateCourierCarrierHandlerInterface;
use Gls\GlsPoland\PrestaShop\MessageHandler\Carrier\CreateShopDeliveryCarrierHandlerInterface;
use Gls\GlsPoland\PrestaShop\MessageHandler\Carrier\DeleteCarrierHandlerInterface;
use Gls\GlsPoland\PrestaShop\MessageHandler\Tab\CreateAdminTabHandlerInterface;
use Gls\GlsPoland\PrestaShop\MessageHandler\Translation\ImportTranslationsHandlerInterface;

final class CommandBus extends BaseCommandBus implements ServiceSubscriberInterface
{
    public static function getSubscribedServices(): array
    {
        return [
            CreateAdminTabCommand::class => CreateAdminTabHandlerInterface::class,
            CreateShopDeliveryCarrierCommand::class => CreateShopDeliveryCarrierHandlerInterface::class,
            CreateCourierCarrierCommand::class => CreateCourierCarrierHandlerInterface::class,
            DeleteCarrierCommand::class => DeleteCarrierHandlerInterface::class,
            ImportTranslationsCommand::class => ImportTranslationsHandlerInterface::class,
        ];
    }
}
